<?php

namespace App\Http\Controllers\TherapistCommunitys;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Certification;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityCertifications\CreateRequest;
use App\Http\Resources\Web\CertificationsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistCommunityCertificationsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist_community');

      // $this->middleware('permission:therapist_community_certifications.index');
      // $this->middleware('permission:therapist_community_certifications.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_community_certifications.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_community_certifications.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_community_certifications.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_community_certifications.import',['only' => ['import']])
      // $this->middleware('permission:therapist_community_certifications.update|therapist_community_certifications.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist_community = auth()->user()->therapist_community;
    if($req != null){
      $therapist_community_certifications =  $therapist_community->therapist_community_certifications()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_community_certifications =  $therapist_community_certifications->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_community_certifications =  $therapist_community_certifications->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_community_certifications = $therapist_community_certifications->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_community_certifications = $therapist_community_certifications->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_community_certifications = $therapist_community_certifications->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_community_certifications = $therapist_community_certifications->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_community_certifications = $therapist_community_certifications->get();
        return $therapist_community_certifications;
      }
      $totalTherapistCommunityCertifications = $therapist_community_certifications->count();
      $therapist_community_certifications = $therapist_community_certifications->paginate($req->perPage);
      $therapist_community_certifications = CertificationsResource::collection($therapist_community_certifications)->response()->getData(true);

      return $therapist_community_certifications;
    }
    $therapist_community_certifications = CertificationsResource::collection($therapist_community->therapist_community_certifications()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_community_certifications;
  }

  /********* FETCH ALL TherapistCommunityCertifications ***********/
    public function index()
    {
        $therapist_community_certifications =  $this->getter();
        $response = generateResponse($therapist_community_certifications,count($therapist_community_certifications['data']) > 0 ? true:false,'TherapistCommunityCertifications Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCommunityCertifications FOR Search ***********/
   public function filter(Request $request){
     $therapist_community_certifications = $this->getter($request);
     $response = generateResponse($therapist_community_certifications,count($therapist_community_certifications['data']) > 0 ? true:false,'Filter TherapistCommunityCertifications Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistCommunityCertification ***********/
    public function store(CreateRequest $request)
    {
      $therapist_community = auth()->user()->therapist_community;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_community_certifications');
      $therapist_community_certification = $therapist_community->therapist_community_certifications()->create($data);
      $therapist_community_certification = $therapist_community->therapist_community_certifications()->withAll()->find($therapist_community_certification->id);
      $therapist_community_certification = new CertificationsResource($therapist_community_certification);
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_community_certification)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_certification->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_certification = $therapist_community->therapist_community_certifications()->withAll()->find($therapist_community_certification);
        if($therapist_community_certification){
          $therapist_community_certification = new CertificationsResource($therapist_community_certification);
          $response = generateResponse($therapist_community_certification,true,'TherapistCommunityCertification Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityCertification Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunityCertification ***********/
    public function update(CreateRequest $request, Certification $therapist_community_certification)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_certification->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_community_certifications',$therapist_community_certification->image);
        } else {
            $data['image'] = $therapist_community_certification->image;
        }
        $therapist_community_certification->update($data);
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistCommunityCertification Status***********/
    public function updateStatus(Request $request,Certification $therapist_community_certification){
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_certification->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_certification->update([
          'is_active' => $therapist_community_certification->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistCommunityCertification Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunityCertification ***********/
    public function destroy(Request $request,Certification $therapist_community_certification)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_certification->therapist_community_id != $therapist_community->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_community_certification->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_community_certification->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunityCertification ***********/
    public function destroyPermanently(Request $request,$therapist_community_certification)
    {
        $therapist_community= auth()->user()->therapist_community;
        $therapist_community_certification = $therapist_community->therapist_community_certifications()->withTrashed()->find($therapist_community_certification);
        if($therapist_community_certification){
            if($therapist_community_certification->therapist_community_id != $therapist_community->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_community_certification->trashed()) {
            $therapist_community_certification->forceDelete();
            $response = generateResponse(null,true,'TherapistCommunityCertification Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityCertification is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityCertification not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistCommunityCertification ***********/
    public function restore(Request $request,$therapist_community_certification)
    {
      $therapist_community= auth()->user()->therapist_community;
      $therapist_community_certification = $therapist_community->therapist_community_certifications()->withTrashed()->find($therapist_community_certification);
          if ($therapist_community_certification->trashed()) {
            $therapist_community_certification->restore();
            $response = generateResponse(null,true,'TherapistCommunityCertification Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityCertification is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
